﻿var actionLogic = {
    questionId: 0,
    nextId: 1000                // Id is used to identigy uniquely action rows. This is more for row update, once the action has been modified we use the row data (properties or editData)
}

a4.top().$(document).ready(function () {
    a4.top().initDocument(document);
});

$(document).ready(function () {
    setUIEvents();
    actionLogic.questionId = $("#QuestionId", document).val();
    actionLogic.nextId = parseInt($("#NextId", document).val());


});

function setUIEvents() {
    var content = $(document);

    content.on("click", ".v-questionActionEditor .h-addBranchTo", function () {
        var content = $(this).closest("#main");
        var isPostAnswer = $(this).closest(".v-postAnswerList").length > 0;
        modalDialog.showWindow(a4.top().questionnaireEditor.getUrl("BranchToAndExitSurveyEditor", { questionId: actionLogic.questionId, actionId: 0, useActionContent: true, actionType: "BranchTo", autoSave: false, isPostAnswer: isPostAnswer }), 400, 950);
    });

    content.on("click", ".v-questionActionEditor .h-addLogic", function () {
        var content = $(this).closest("#main");
        var isPostAnswer = $(this).closest(".v-postAnswerList").length > 0;
        modalDialog.showWindow(a4.top().questionnaireEditor.getUrl("LogicActionEditor", { questionId: actionLogic.questionId, actionId: 0, useActionContent: true, actionType: "ComputeVariable", autoSave: false, isPostAnswer: isPostAnswer }), 550, 920);
    });

    content.on("click", ".h-copyActions", function (event) {
        var editor = $(this).closest(".v-questionActionEditor");

        if (!a4.top().questionnaireEditor.actionsLoaded) {
            a4.top().questionnaireEditor.loadQuestionnaireActions(function () { showCopyActionsFromDialog(editor) });
        }
        else {
            showCopyActionsFromDialog(editor);
        }
    });

    content.on("click", ".h-editLogicRow", function () {
        var action = $(this).closest(".v-questionEditableItem");
        var isPostAnswer = action.closest(".v-postAnswerList").length > 0;
        setUnsavedRow(action);
        var actionId = action.attr("data-actionId");
        var type = action.attr("data-actionType");
        var editData = "";

        // If the action has been edited
        if (action.data('actionType')) {
            var logic = actionObject(action);
            type = logic.Action;
            editData = JSON.stringify(logic);
        }
        else if ($(".v-editData", action).val() != "") {    // If the action may have change from orginal state (case save actions without saving question and re-editing actions)
            var data = formatEditActionData($(".v-editData", action).val());
            var logic = $.parseJSON(data);
            logic.Action = action.attr("data-actionType");
            editData = JSON.stringify(logic);
        }

        var branchType = (type == "BranchTo" || type == "ExitSurvey");
        var page = branchType ? "BranchToAndExitSurveyEditor" : "LogicActionEditor";
        var windowHeight = branchType ? 400 : 550;
        var useActionContent = (editData == "");

        var loadEditContentFunction = function () {
            if (!useActionContent) {
                a4.callServerMethod(a4.top().questionnaireEditor.getUrl(page), { questionId: actionLogic.questionId, actionId: actionId, editData: editData, isPostAnswer: isPostAnswer },
                    function (result) {
                        $("iframe").contents().find('.v-actionContent').html(result);

                        if (frames[0] && frames[0].initializeEdition) {
                            frames[0].initializeEdition();
                        }
                    });
            }
        }        

        modalDialog.showWindow(a4.top().questionnaireEditor.getUrl(page, { questionId: actionLogic.questionId, actionId: actionId, useActionContent: useActionContent, actionType: type, autoSave: false, isPostAnswer: isPostAnswer }), windowHeight, 950, { initFunction: loadEditContentFunction });
    });

    content.on("click", ".h-copyLogicRow", function () {
        var row = $(this).closest(".v-questionEditableItem");
        setUnsavedRow(row);
        var actionEditor = row.closest(".v-questionActionEditor:visible");
        addActionRowEvent(actionEditor, row);
    });

    content.on("click", ".v-advanceContent .h-deleteRow", function () {
        var item = $(this).closest(".v-questionEditableItem");
        item.addClass("deleted").hide();

        // Remove compute variable from list
        if (item.attr("data-actiontype") == "ComputeVariable") {
            var name = $(".v-actionDisplay", item).text().split('=', 1)[0].trim().toUpperCase();
            a4.top().questionnaireEditor.updateVariableList(name, null, item)
        }

        a4.top().questionnaireEditor.replaceItemIndexes(item);
    });

    content.on("click", ".h-addSelectedActions", function (event) {
        var container = $(this).closest("#CopyActionsFromPanel");
        var selectedContainer = $(".v-selectedActions", container);
        var deleteButton = $(".v-deleteActionDiv", container).html();

        $(".v-questionActions option:selected", container).each(function () {
            $("<div class='item v-item' data-id='" + $(this).val() + "'>" + $(this).text() + deleteButton + "</div>").appendTo(selectedContainer);
        });

        $(".v-selectedPanel .v-selectedActions", container).sortable({
            containment: 'parent',
            items: '.item',
            axis: 'y'
        });
    });

    content.on("click", ".h-deleteCopyAction", function (event) {
        $(this).closest(".v-item").remove();
    });

    $("#submit").on("click", function () {
        var preLoad = getActions($(".v-preLoadList", document));
        var postAnswer = getActions($(".v-postAnswerList", document));
        var autoSave = $(document).find("#AutoSave").val() == "true";
        var questionId = $(document).find("#QuestionId").val();

        a4.top().questionnaireEditor.questionController.updateAdvanceLogic(actionLogic.questionId, JSON.stringify(preLoad), JSON.stringify(postAnswer), autoSave);
    });

    $("#cancel").on("click", function () {
        var questionId = $(document).find("#QuestionId").val();
        var question = a4.top().questionnaireEditor.blockController.getBlockItemElementFromId(questionId);

        if (question.length > 0) {
            question.removeData("preLoad");
            question.removeData("postAnswer");
        }

        return modalDialog.close();
    });

    $(".v-questionActionTable", content).sortable({
        connectWith: ".v-questionActionTable",
        dropOnEmpty: true,
        items: ".v-questionEditableItem",
        containment: ".v-advanceContent",
        handle: ".move-handle",
        cursor: "move",
        forceHelperSize: true,
        forcePlaceholderSize: true,
        helper: function (e, ui) {
            ui.children().each(function () {
                $(this).width($(this).width());
                $(this).height($(this).height());
            });

            return ui;
        },
        update: function (event, ui) {
            var tbody = $(this).find(".v-questionActionBody");

            ui.item.addClass("moved");
            a4.top().questionnaireEditor.changeActiveRow(ui.item);

            if (ui.sender && $(".v-questionEditableItem", tbody).length == 0) {
                ui.item.appendTo(tbody);
            }

            $(".v-questionEditableItem", tbody).each(function (i, e) {
                $(".v-itemIndex", e).text(i + 1);
            });
        }
    });
}

function formatEditActionData(action) {
    return $(action.split(/ _/)).map(function () {
        return this.charAt(0).toUpperCase() + this.slice(1);
    }).get().join("");
}

function getActions(actionEditor) {
    return $(".v-questionActionBody .v-questionEditableItem:not(.deleted)", actionEditor).map(function () { return actionObject($(this)); }).get();
}

function actionObject(actionRow) {
    var item = new Object();
    item.Id = actionRow.attr("id").replace("ActionRow", "");
    item.Action = actionRow.data('actionType');
    item.Properties = actionRow.data('properties');
    item.ExecutionCondition = actionRow.data('executionCondition');
    item.CopyProperties = actionRow.data('copyProperties');

    if (!item.Action) {
        item.Action = $(".v-questionActionId", actionRow).val();
    }

    // If we are getting an unsaved action that hasn't been modified (reload), set object from edit data
    if (item.Id == 0 && item.Properties == null && $(".v-editData", actionRow).val() != "") {
        var logic = $.parseJSON($(".v-editData", actionRow).val());
        item.Properties = JSON.stringify(logic.Properties)
        item.ExecutionCondition = JSON.stringify(logic.ExecutionCondition)
        item.CopyProperties = JSON.stringify(logic.CopyProperties)
    }

    return item;
}

function setActionItem(questionId, actionId, actionType, actionTypeText, properties, executionCondition, conditionDisplay, newAction, isPostAnswer) {
    var actionList = isPostAnswer ? $(".v-postAnswerList") : $(".v-preLoadList");
    var row = null;

    if (newAction && actionId == 0) {
        addActionRowEvent(actionList);
        row = $(".v-questionActionBody .v-questionEditableItem:last", actionList);
        a4.top().questionnaireEditor.changeActiveRow(row);
    }
    else {
        row = $(".v-questionActionBody .v-questionEditableItem[data-actionId=" + actionId + "]", actionList);
        row.addClass("updated");
    }

    setActionRowData(row, questionId, actionId, actionType, actionTypeText, properties, executionCondition, conditionDisplay);
    $.fancybox.close();
}

function addActionRowEvent(actionEditor, takeRow) {
    var rowId = $(".v-questionActionBody tr:visible", actionEditor).length + 1;

    if (takeRow !== undefined) {
        copyActionRow(actionEditor, takeRow, rowId);
    }
    else {
        var newRow = $(".v-newLogic tbody tr", actionEditor.closest(".v-advanceContent")).clone(false);
        $(".v-itemIndex", newRow).text(rowId);
        $(newRow).appendTo($("table .v-questionActionBody", actionEditor));
        setRowActionId(newRow);
    }
}


function setActionRowData(row, questionId, actionId, actionType, actionTypeText, properties, executionCondition, conditionDisplay) {
    var isComputeVariable = (actionType == "ComputeVariable");

    if (isComputeVariable) {
        var initialVariableName = _.find(properties, function (item) { return item.Name == "InitialCalculatedVariableName" }).Value;
        properties = _.reject(properties, function (v) { return v.Name == "InitialCalculatedVariableName"; });
        var variableName = _.find(properties, function (item) { return item.Name == "CalculatedVariableName" }).Value;

        if (row.data('copyProperties') != undefined) {
            row.data('copyProperties')[0].Value = variableName;
        }

        a4.top().questionnaireEditor.updateVariableList(initialVariableName, variableName, questionId);
    }

    $(".v-actionAction", row).text(actionTypeText);
    $(".v-actionDisplay", row).text(a4.top().questionnaireEditor.resources.Loading);
    $(".v-questionActionId", row).attr("value", actionType);
    row.data('actionType', actionType);
    row.data('properties', properties);
    row.data('executionCondition', executionCondition);
    row.attr("data-actionType", actionType)

    if (isComputeVariable && row.data('copyProperties') != undefined) {
        var variableName = _.find(row.data('properties'), function (item) { return item.Name == "CalculatedVariableName" }).Value;
        row.data('copyProperties')[0].Value = variableName;
    }

    var logic = actionObject(row);
    $(".v-editData", row).val(JSON.stringify(logic));

    if (conditionDisplay.indexOf("{executionCondition}") == -1) {
        $(".v-actionDisplay", row).text(conditionDisplay);
    }
    else {
        a4.callServerMethod(a4.top().questionnaireEditor.getUrl("GetSkipLogicTextualCondition"), { skiplogicJSON: JSON.stringify(executionCondition) },
            function (result) {
                $(".v-actionDisplay", row).text(conditionDisplay.replace("{executionCondition}", result));
            },
			function () {
			    $(".v-actionDisplay", row).text(conditionDisplay.replace("{executionCondition}", ""));
			});
    }
}

function copyActionRow(actionEditor, takeRow, rowId) {
    var newRow = $('<div>').append(takeRow.clone()).remove();
    $(".v-itemIndex", newRow).text(rowId);
    var actionId = takeRow.attr("id").replace("ActionRow", "");
    var isComputeVariable = $(".v-questionActionId", newRow).val() == "ComputeVariable"

    // Row not serialized in database
    if (actionId != "0" && takeRow.hasClass("copied")) {
        actionId = 0;
    }

    if (!isComputeVariable) {
        if (actionId == "0") {      // Row already has edit properties no need to retrieve data
            completeCopyRowAction(newRow, takeRow, actionEditor, "", {}, isComputeVariable);
        }
        else {
            a4.callServerMethod(a4.top().questionnaireEditor.getUrl("GetActionSerializedData"), { questionId: actionLogic.questionId, actionId: actionId },
                function (result) {
                    completeCopyRowAction(newRow, takeRow, actionEditor, result, {}, isComputeVariable);
                },
                function () { }
            );
        }
    }
    else {
        var variableName = retrieveComputeVariableName(takeRow.data('properties'));

        var callback = function (result) {
            var display = $(".v-actionDisplay", newRow).text();
            $(".v-actionDisplay", newRow).text(result.Value + " = " + display.substring(display.indexOf("=") + 1));

            var jsonData = result.Data;
            delete result["Data"];
            completeCopyRowAction(newRow, takeRow, actionEditor, jsonData, $.makeArray(result), isComputeVariable, result.Value);
        };

        // If new row with no properties then load from edit data
        if (actionId == 0 && variableName == null) {
            var action = $.parseJSON($(".v-editData", takeRow).val());
            variableName = retrieveComputeVariableName(action.Properties);
        }

        a4.top().questionnaireEditor.createComputeVariableActionCopy(actionLogic.questionId, actionId, variableName, callback);
    }
}

function retrieveComputeVariableName(list) {
    return (list != undefined)
            ? _.find(list, function (item) { return item.Name == "CalculatedVariableName" }).Value
            : null;    // For newly created cv
}

function completeCopyRowAction(newRow, takeRow, actionEditor, editData, propertyVal, isComputeVariable, newComputeVariableName) {
    var row = $(newRow.html());
    row.appendTo($("table .v-questionActionBody", actionEditor));
    $(".v-questionActionId", row).val($(".v-questionActionId", takeRow).val());
    setRowActionId(row);
    row.attr("id", "ActionRow0");

    // START - Set the edit data for the row
    var useRowData = ($(".v-editData", takeRow).val() != "");
    var startData = useRowData ? $(".v-editData", takeRow).val() : editData;
    var action = JSON.parse(startData);
    action.Id = actionLogic.nextId;
    startData = JSON.stringify(action);
    $(".v-editData", row).val(startData);
    // END - Set the edit data for the row

    // Copy from take row
    row.data('actionType', takeRow.data('actionType'));
    row.data('properties', jQuery.extend(true, [], takeRow.data('properties') ? takeRow.data('properties') : action.Properties));
    row.data('executionCondition', takeRow.data('executionCondition') ? takeRow.data('executionCondition') : action.ExecutionCondition);

    // Overwrite the compute variable name in the properties
    if (isComputeVariable && newComputeVariableName) {
        var cvp = _.find(row.data('properties'), function (item) { return item.Name == "CalculatedVariableName" });

        if (cvp) {
            cvp.Value = newComputeVariableName;
        }
    }

    row.attr("data-actionType", takeRow.attr('data-actionType'));
    row.addClass("copied");
    a4.top().questionnaireEditor.changeActiveRow(row);
}

function setUnsavedRow(row) {
    if (row.attr("data-actionId") == "0") {
        setRowActionId(row);
    }
}

function setRowActionId(row) {
    actionLogic.nextId += 1;
    row.attr("data-actionId", actionLogic.nextId);
}

function showCopyActionsFromDialog(editor) {
    var questionsWithActions = _.pluck(a4.top().questionnaireEditor.actions, "questionName");
    var questionActions = _.filter(a4.top().questionnaireEditor.getSortedQuestions(), function (q) { return _.contains(questionsWithActions, q.name); });

    var content = $('<div id="CopyActionsContainer">').append($("#v-copyActionsPanel").html());

    var contentResources = {
        "Title": a4.top().questionnaireEditor.resources.CopyActionsFrom,
        "Message": content
    };

    modalDialog.showConfirmDialog(contentResources,
        function () {
            var container = $('#CopyActionsContainer');
            var selected = [];

            $(".v-selectedActions .v-item", container).each(function () {
                selected.push($(this).attr("data-id"));
            });

            if (_.size(selected) > 0) {
                completeCopyActionsFromQuestionEvent(editor, JSON.stringify(selected));
            }
        }, 380, 680, null, null, {
            initFunction: function () {
                var container = $('#CopyActionsContainer');

                $(".v-copyFromQuestion", container).a4autocomplete({
                    valueProperty: "value",
                    labelProperty: "name",
                    data: questionActions,
                    tooltipProperty: "questionId",
                    tooltipData: function (autocomplete, tooltip, questionId) {
                        a4.getTooltipQuestionText(autocomplete, tooltip, a4.top().questionnaireEditor.Id, questionId);
                    },
                    select: function (event, ui) {
                        if (ui.item) {
                            copyActionQuestionChangeEvent(container, ui.item.value);
                        }
                        else {
                            $("#CopyActionsFromPanel .v-actionsContainer", container).hide();
                        }
                    }
                });
            }
        });
}

function copyActionQuestionChangeEvent(container, value) {
    var actionsContainer = $("#CopyActionsFromPanel .v-actionsContainer", container);
    var actionsList = $(".v-questionActions", actionsContainer);
    $("option", actionsList).remove();

    _.each(a4.top().questionnaireEditor.getActionsByQuestionId(value), function (item) {
        var text = a4.top().questionnaireEditor.resources["Action_" + item.name] + " -> " + item.summary;
        actionsList.append($("<option></option>").attr("value", item.value).attr("title", text).text(text));
    });

    actionsContainer.show();
    $("option", actionsList).prop("selected", true);
}

function completeCopyActionsFromQuestionEvent(editor, items) {
    a4.callServerMethod(a4.top().questionnaireEditor.getUrl("GetActionCopies"), { questionId: actionLogic.questionId, copyActions: items },
        function (result) {
            if (result) {
                $.each(result, function (index, item) {
                    addActionRowEvent(editor);
                    var newRow = $(".v-questionActionBody .v-questionEditableItem:last", editor);
                    $(".v-questionActionId", newRow).attr("value", item.ActionType);
                    $(".v-actionAction", newRow).text(a4.top().questionnaireEditor.resources["Action_" + item.ActionType]);
                    $(".v-actionDisplay", newRow).text(item.Summary);
                    newRow.attr("data-actionType", item.ActionType);
                    setRowActionId(newRow);
                    newRow.addClass("copied");

                    if (item.ActionType == "ComputeVariable") {
                        var action = $.parseJSON(item.Data);

                        // Change the compute variable in the properties with the new variable name
                        _.find(action.Properties, function (item) { return item.Name == "CalculatedVariableName" }).Value = item.Value;
                        item.Data = JSON.stringify(action);

                        a4.top().questionnaireEditor.addComputeVariable(item, actionLogic.questionId);
                    }

                    // Set the row data for edition
                    $(".v-editData", newRow).val(item.Data);
                });
            }
        },
        function (error) {
            a4.onAjaxPageMethodError(error);
        }
	);
}



